/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.designer.properties.resourcestab;

import filenet.sim.toolkit.designer.properties.resources.VWSIMResource;
import filenet.sim.toolkit.designer.properties.resourcestab.VWSIMDailyPropertiesPanel;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

class VWSIMWeeklyPropertiesPanel
extends VWSIMDailyPropertiesPanel
implements ActionListener {
    private JCheckBox m_sundayCheckBox = null;
    private JCheckBox m_mondayCheckBox = null;
    private JCheckBox m_tuesdayCheckBox = null;
    private JCheckBox m_wednesdayCheckBox = null;
    private JCheckBox m_thursdayCheckBox = null;
    private JCheckBox m_fridayCheckBox = null;
    private JCheckBox m_saturdayCheckBox = null;

    public void setEnabled(boolean bEnable) {
        super.setEnabled(bEnable);
        this.m_mondayCheckBox.setEnabled(bEnable);
        this.m_tuesdayCheckBox.setEnabled(bEnable);
        this.m_wednesdayCheckBox.setEnabled(bEnable);
        this.m_thursdayCheckBox.setEnabled(bEnable);
        this.m_fridayCheckBox.setEnabled(bEnable);
        this.m_saturdayCheckBox.setEnabled(bEnable);
        this.m_sundayCheckBox.setEnabled(bEnable);
    }

    public void releaseReferences() {
        super.releaseReferences();
        this.m_mondayCheckBox = null;
        this.m_tuesdayCheckBox = null;
        this.m_wednesdayCheckBox = null;
        this.m_thursdayCheckBox = null;
        this.m_fridayCheckBox = null;
        this.m_saturdayCheckBox = null;
        this.m_sundayCheckBox = null;
    }

    public void actionPerformed(ActionEvent event) {
        super.actionPerformed(event);
        Object src = event.getSource();
        if (src == this.m_sundayCheckBox || src == this.m_mondayCheckBox || src == this.m_tuesdayCheckBox || src == this.m_wednesdayCheckBox || src == this.m_thursdayCheckBox || src == this.m_fridayCheckBox || src == this.m_saturdayCheckBox) {
            this.performWeekdayCheckBoxesAction();
        }
    }

    protected JPanel getMainControlPanel() {
        try {
            JPanel mainPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 21;
            gbCons.gridwidth = 0;
            gbCons.gridheight = 1;
            gbCons.insets = new Insets(5, 5, 5, 5);
            this.initDateTimeControls(mainPanel, gbCons);
            this.initDurationControls(mainPanel, gbCons);
            this.initDayControls(mainPanel, gbCons);
            return mainPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    protected JPanel getAdvancedControlPanel() {
        try {
            VWToolbarBorder advancedToolbarBorder = new VWToolbarBorder(VWSIMResource.s_advancedSettings);
            JPanel advancedPanel = advancedToolbarBorder.getClientPanel();
            advancedPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 21;
            gbCons.gridwidth = 0;
            gbCons.gridheight = 1;
            gbCons.insets = new Insets(5, 5, 5, 5);
            this.initStartFromControls(advancedPanel, gbCons, VWSIMResource.s_weeksAfterSimulationStarts);
            this.initRepeatEveryControls(advancedPanel, gbCons, VWSIMResource.s_weeks);
            this.initEndAfterControls(advancedPanel, gbCons);
            return advancedToolbarBorder;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    protected void reinitialize() {
        try {
            super.reinitialize();
            int nDays = this.m_shiftDef.getActiveDays();
            this.m_sundayCheckBox.removeActionListener(this);
            this.m_sundayCheckBox.setSelected((nDays & 0x40) == 64);
            this.m_sundayCheckBox.addActionListener(this);
            this.m_mondayCheckBox.removeActionListener(this);
            this.m_mondayCheckBox.setSelected((nDays & 1) == 1);
            this.m_mondayCheckBox.addActionListener(this);
            this.m_tuesdayCheckBox.removeActionListener(this);
            this.m_tuesdayCheckBox.setSelected((nDays & 2) == 2);
            this.m_tuesdayCheckBox.addActionListener(this);
            this.m_wednesdayCheckBox.removeActionListener(this);
            this.m_wednesdayCheckBox.setSelected((nDays & 4) == 4);
            this.m_wednesdayCheckBox.addActionListener(this);
            this.m_thursdayCheckBox.removeActionListener(this);
            this.m_thursdayCheckBox.setSelected((nDays & 8) == 8);
            this.m_thursdayCheckBox.addActionListener(this);
            this.m_fridayCheckBox.removeActionListener(this);
            this.m_fridayCheckBox.setSelected((nDays & 0x10) == 16);
            this.m_fridayCheckBox.addActionListener(this);
            this.m_saturdayCheckBox.removeActionListener(this);
            this.m_saturdayCheckBox.setSelected((nDays & 0x20) == 32);
            this.m_saturdayCheckBox.addActionListener(this);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void initDayControls(JPanel childPanel, GridBagConstraints gbCons) {
        try {
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 21;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.insets = new Insets(5, 5, 5, 5);
            JLabel weekdaysLabel = new JLabel(VWSIMResource.s_colon.toString(VWSIMResource.s_weekdays));
            childPanel.add((Component)weekdaysLabel, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.anchor = 23;
            gbCons.gridwidth = 0;
            JPanel daysPanel = new JPanel(new GridLayout(1, 7));
            childPanel.add((Component)daysPanel, gbCons);
            this.m_sundayCheckBox = new JCheckBox(VWSIMResource.s_sunday);
            this.m_sundayCheckBox.setSelected(true);
            this.m_sundayCheckBox.addActionListener(this);
            daysPanel.add(this.m_sundayCheckBox);
            this.m_mondayCheckBox = new JCheckBox(VWSIMResource.s_monday);
            this.m_mondayCheckBox.setSelected(true);
            this.m_mondayCheckBox.addActionListener(this);
            daysPanel.add(this.m_mondayCheckBox);
            this.m_tuesdayCheckBox = new JCheckBox(VWSIMResource.s_tuesday);
            this.m_tuesdayCheckBox.setSelected(true);
            this.m_tuesdayCheckBox.addActionListener(this);
            daysPanel.add(this.m_tuesdayCheckBox);
            this.m_wednesdayCheckBox = new JCheckBox(VWSIMResource.s_wednesday);
            this.m_wednesdayCheckBox.setSelected(true);
            this.m_wednesdayCheckBox.addActionListener(this);
            daysPanel.add(this.m_wednesdayCheckBox);
            this.m_thursdayCheckBox = new JCheckBox(VWSIMResource.s_thursday);
            this.m_thursdayCheckBox.setSelected(true);
            this.m_thursdayCheckBox.addActionListener(this);
            daysPanel.add(this.m_thursdayCheckBox);
            this.m_fridayCheckBox = new JCheckBox(VWSIMResource.s_friday);
            this.m_fridayCheckBox.setSelected(true);
            this.m_fridayCheckBox.addActionListener(this);
            daysPanel.add(this.m_fridayCheckBox);
            this.m_saturdayCheckBox = new JCheckBox(VWSIMResource.s_saturday);
            this.m_saturdayCheckBox.setSelected(true);
            this.m_saturdayCheckBox.addActionListener(this);
            daysPanel.add(this.m_saturdayCheckBox);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performWeekdayCheckBoxesAction() {
        int days = 0;
        try {
            if (this.m_sundayCheckBox.isSelected()) {
                days |= 0x40;
            }
            if (this.m_mondayCheckBox.isSelected()) {
                days |= 1;
            }
            if (this.m_tuesdayCheckBox.isSelected()) {
                days |= 2;
            }
            if (this.m_wednesdayCheckBox.isSelected()) {
                days |= 4;
            }
            if (this.m_thursdayCheckBox.isSelected()) {
                days |= 8;
            }
            if (this.m_fridayCheckBox.isSelected()) {
                days |= 0x10;
            }
            if (this.m_saturdayCheckBox.isSelected()) {
                days |= 0x20;
            }
            this.m_shiftDef.setActiveDays(days);
            this.m_propertyData.setDirty();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

